/*
 * File:   user.c
 *
 * Created on February 9, 2010, 10:53 AM
 */
/*******************************************************************************
Copyright (c) 2014 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <p33Fxxxx.h>
#include <xc.h>
#include <spi.h>

#include "define.h"
#include "DRV_MCP2515.h"
#include "user.h"

void initClock(void)
{
     // System Clock:
    // FOSC = 8M /2 * (38+2) / 2 = 160M/2 = 80MHz
    // FCY  = 80M/2 = 40MHz
    CLKDIVbits.PLLPOST = 0;
    PLLFBD = 38;

    // Define is used in delay routines
#define Fcy 40000000

}

void initIOPorts(void)
{
    // LED as output
    LED3_PIN = OUTPUT;
    LED3 = OFF;
    LED4_PIN = OUTPUT;
    LED4 = OFF;
    LED5_PIN = OUTPUT;
    LED5 = OFF;
    LED6_PIN = OUTPUT;
    LED6 = OFF;
    LED7_PIN = OUTPUT;
    LED7 = OFF;
    LED8_PIN = OUTPUT;
    LED8 = OFF;
    LED9_PIN = OUTPUT;
    LED9 = OFF;
    LED10_PIN = OUTPUT;
    LED10 = OFF;

    // Buttons as inputs
    S3_PIN = INPUT;
    S4_PIN = INPUT;
    //S5_PIN = INPUT; // FIXME: Can't use S5 and LEDSs at the same time on Explorer board!
    S6_PIN = INPUT;

    CAN_MOSI_PIN        = OUTPUT;
    CAN_SCK_PIN         = OUTPUT;
    CAN_CS_PIN          = OUTPUT;
    CAN_STBY_PIN        = OUTPUT;
    CAN_INTERRUPT_PIN   = INPUT;
    CAN_MISO            = INPUT;

    Nop();
}

void OpenSPI()
{
    // Mode 0,0
    SPI1CON1 = 0;
    SPI1CON1bits.CKE = 1;
    SPI1CON1bits.MSTEN = 1;
    SPI1CON1bits.SMP = 1;   // Set after MSTEN!
    SPI1CON1bits.PPRE = 3;
    SPI1CON1bits.SPRE = 0;

    // No Frame mode; no enhanced buffer on my dsPIC33F
    SPI1CON2 = 0;

    SPI1STATbits.SPIEN = 1;
}

void initCANport(void)
{
    // Initialize SPI1
    CAN_CS_HIGH();

    // Open SPI1
    OpenSPI();

    // Reset MCP2515; this makes sure device is in Configuration Mode
    DRV_MCP2515_Reset();

    // Configure Bit time; 20 MHz crystal; 500kbps
    Nop(); Nop();
    DRV_MCP2515_BIT_TIME_CONFIG btConfig;

    btConfig.BRP = 0;
    btConfig.PropSeg = DRV_MCP2515_PROP_7TQ;
    btConfig.PhaseSeg1 = DRV_MCP2515_PHSEG1_8TQ;
    btConfig.PhaseSeg2 = DRV_MCP2515_PHSEG2_4TQ;
    btConfig.SJW = DRV_MCP2515_SJW_4TQ;

    btConfig.BusSampling = DRV_MCP2515_SAMPLE_TRICE;
    btConfig.PhaseSeg2Config = DRV_MCP2515_PHSEG2_CNF3;
    btConfig.SOFPinConfig = DRV_MCP2515_CLKO_PIN;
    btConfig.WakeUpFilterEnable = DRV_MCP2515_WAKFIL_ENABLE;

    DRV_MCP2515_ConfigurationSet(&btConfig);

    /* Configure Filter objects */
    DRV_MCP2515_FILTEROBJ_ID fObj;
    // Allow CAN Base Frame with ID 0x1xx
    fObj.SID = MSG_ID_LED_CONTROL;
    fObj.EID = 0x0;
    fObj.EXIDE = 0;

    DRV_MCP2515_FilterConfigure(DRV_MCP2515_FILTER0, &fObj);
    DRV_MCP2515_FilterConfigure(DRV_MCP2515_FILTER1, &fObj);
    DRV_MCP2515_FilterConfigure(DRV_MCP2515_FILTER2, &fObj);
    DRV_MCP2515_FilterConfigure(DRV_MCP2515_FILTER3, &fObj);
    DRV_MCP2515_FilterConfigure(DRV_MCP2515_FILTER4, &fObj);
    DRV_MCP2515_FilterConfigure(DRV_MCP2515_FILTER5, &fObj);

    /* Configure mask objects */
    DRV_MCP2515_MASKOBJ_ID mObj;
    mObj.MSID = 0x3FF;
    mObj.MEID = 0x0;
    DRV_MCP2515_MaskConfigure(DRV_MCP2515_MASK0, &mObj);
    DRV_MCP2515_MaskConfigure(DRV_MCP2515_MASK1, &mObj);

    // Configure receive mode
    DRV_MCP2515_RX_CONFIG rxConfig;
    rxConfig.RXB0_ReceiveMode = DRV_MCP2515_RXM_USE_FILTER;
    rxConfig.RXB1_ReceiveMode = DRV_MCP2515_RXM_USE_FILTER;
    rxConfig.RXB_RollOver = DRV_MCP2515_RXB_ROLLOVER_ENABLED;
    DRV_MCP2515_ReceiveConfigurationSet(&rxConfig);

    // Clear all flags
    DRV_MCP2515_ModuleEventClear(DRV_MCP2515_ALL_EVENTS);

    // Enable receive interrupt
    DRV_MCP2515_ModuleEventEnable(DRV_MCP2515_RXB0_EVENT);

    // Set Normal/Loopback mode
    DRV_MCP2515_OperationModeSelect(DRV_MCP2515_NORMAL_MODE);
}

ButtonState debounceButtons()
{
#define DEBOUCE_LOOPS 50

    static ButtonState lastButtonState, state;
    static unsigned char isInitialized = FALSE;
    static unsigned char n = DEBOUCE_LOOPS;
    ButtonState newButtonState;

    // Initialize
    if (!isInitialized) {
        lastButtonState.byte = 0;
        state = lastButtonState;
        n = DEBOUCE_LOOPS;
        isInitialized = TRUE;
    }

    // Read new state
    newButtonState.byte = 0;
    if (S3) newButtonState.State |= S3_POS;
    if (S4) newButtonState.State |= S4_POS;
    if (S5) newButtonState.State |= S5_POS;
    if (S6) newButtonState.State |= S6_POS;


    // Compare to old and debounce
    if (newButtonState.State == lastButtonState.State) {
        if (n>0) n--;
        if (n==1) {
            // Debounce done
            state.State = newButtonState.State;
            state.Changed = TRUE;
        }
        else {
             state.Changed = FALSE;
        }
    }
    else {
        // Buttons have changed, need to start debouncing
        n = DEBOUCE_LOOPS;
        lastButtonState.State = newButtonState.State;
    }

    return state;
}

void updateButtonLeds(ButtonState btnState)
{
    if (btnState.State & S4_POS) LED3 = ON;
    else LED3 = OFF;
    if (btnState.State & S5_POS) LED4 = ON;
    else LED4 = OFF;
    if (btnState.State & S6_POS) LED5 = ON;
    else LED5 = OFF;
    if (btnState.State & S3_POS) LED6 = ON;
    else LED6 = OFF;
}

void updateRxLeds(unsigned char *rxd)
{
    if (rxd[0] & S4_POS) LED7 = ON;
    else LED7 = OFF;
    if (rxd[0] & S5_POS) LED8 = ON;
    else LED8 = OFF;
    if (rxd[0] & S6_POS) LED9 = ON;
    else LED9 = OFF;
    if (rxd[0] & S3_POS) LED10 = ON;
    else LED10 = OFF;
}
